@extends('layouts.app')

@section('content')
@extends('compras.menu')

<div id="contenedor_interno" class="container-fluid">
    <div class="row ">
      <div class="col-md-12">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('compras.dashboard_proveedor') }}">Proveedor</a></li>
            <li class="breadcrumb-item active" aria-current="page">Editar</li>
          </ol>
        </nav>
        <form action="{{ route('compras.actualizar_proveedor',$cliente->id) }}" method="POST">
          @csrf
          
        <input type="submit" href="" class="botonColor" value="Actualizar proveedor" />
        <a href="{{route('compras.eliminar_proveedor',$cliente->id)}}" class="btn btn-danger">Eliminar proveedor</a>
      </div>
    </div>
</div>

<div id="contenedor_contenido" class="container-fluid px-lg-5">
  <div class="row">
    <div class="col-md-12">
      
       
        <div class="row">
          <div class="col-md-12">
            <div class="form-group">
              <label>Nombre del Proveedor</label>
              <input type="text" class="form-control" name="nombre" value="{{$cliente->nombre}}" placeholder="Nombre del cliente">
            </div>
          </div>
          <div class="col-md-6">
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">NIT</label>
              <div class="col-sm-8">
                <input type="text" name="nit" class="form-control-plaintext nit" value="{{$cliente->nit}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Dirección</label>
              <div class="col-sm-8">
                <input type="text" name="direccion" class="form-control-plaintext" value="{{$cliente->direccion}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Condiciones de pago</label>
              <div class="col-sm-8">
                <select class="form-control" name="condiciones_pago" id="exampleFormControlSelect1">
                  <option>Días de crédito</option>
                  <option {{ $cliente->condiciones_pago == 1 ? "selected" : "" }}  value="1">Contado</option>
                  <option {{ $cliente->condiciones_pago == 6 ? "selected" : "" }} value="2">8 días</option>
                  <option {{ $cliente->condiciones_pago == 2 ? "selected" : "" }} value="2">15 días</option>
                  <option {{ $cliente->condiciones_pago == 3 ? "selected" : "" }} value="3">30 días</option>
                  <option {{ $cliente->condiciones_pago == 4 ? "selected" : "" }} value="4">45 días</option>
                  <option {{ $cliente->condiciones_pago == 5 ? "selected" : "" }} value="5">60 días</option>
                </select>
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Teléfono de la empresa: </label>
              <div class="col-sm-8">
                <input type="text" name="telefono" class="form-control-plaintext" value="{{$cliente->telefono}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Sitio web	</label>
              <div class="col-sm-8">
                <input type="text" name="sitio_web" class="form-control-plaintext" value="{{$cliente->sitio_web}}" placeholder="">
              </div>
            </div>
            <div class="form-check">
              <input class="form-check-input" type="checkbox" value="1" name="p_interno" id="defaultCheck1" {{$cliente->p_interior==1?'checked':''}} >
              <label class="form-check-label" for="defaultCheck1">
                Local
              </label>
            </div>
            <div class="form-check">
              <input class="form-check-input" type="checkbox" value="1" name="p_externo" id="defaultCheck2" {{$cliente->p_exterior==1?'checked':''}}>
              <label class="form-check-label" for="defaultCheck2">
                Exterior
              </label>
            </div>
          </div>
          <div class="col-md-6">
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Nombre del contacto: </label>
              <div class="col-sm-8">
                <input type="text" name="nombre_contacto1" class="form-control-plaintext" value="{{$cliente->nombre_contacto}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Celular contacto</label>
              <div class="col-sm-8">
                <input type="text" name="celular" class="form-control-plaintext" value="{{$cliente->celular}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Correo electrónico</label>
              <div class="col-sm-8">
                <input type="text" name="correo_electronico" class="form-control-plaintext" value="{{$cliente->correo_electronico}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Puesto de trabajo</label>
              <div class="col-sm-8">
                <input type="text" name="puesto" class="form-control-plaintext" value="{{$cliente->puesto}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Referencia interna</label>
              <div class="col-sm-8">
                <input type="text" name="referencia" class="form-control-plaintext" value="{{$cliente->referencia}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">País</label>
              <div class="col-sm-8">
                <input type="text" name="pais" class="form-control-plaintext" value="{{$cliente->pais}}" placeholder="">
              </div>
            </div>
          </div>
        </div>
        <!-- Productos -->
        <div class="row">
          <div class="col-md-12">
            <ul class="nav nav-tabs" id="myTab">
              <li class="nav-item">
                  <a href="#a1" class="nav-link" data-toggle="tab">Contactos y direcciones</a>
              </li>
              <li class="nav-item">
                  <a href="#a2" class="nav-link" data-toggle="tab">Notas internas</a>
              </li>
              <li class="nav-item">
                  <a href="#a4" class="nav-link" data-toggle="tab">Contabilidad</a>
              </li>
            </ul>
            <div class="tab-content">
              <div class="tab-pane fade" id="a1">
                <br>
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Nombre del contacto: </label>
                      <div class="col-sm-8">
                        <input type="text" name="nombre_contacto[]" class="form-control-plaintext" value="{{$cliente->contactos[0]->nombre_contacto??''}}" placeholder="">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Celular contacto</label>
                      <div class="col-sm-8">
                        <input type="text" name="celular_contacto[]" class="form-control-plaintext" value="{{$cliente->contactos[0]->celular??''}}" placeholder="">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Correo electrónico</label>
                      <div class="col-sm-8">
                        <input type="text" name="correo_electronico_contacto[]" class="form-control-plaintext" value="{{$cliente->contactos[0]->correo_electronico??''}}" placeholder="">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Puesto de trabajo</label>
                      <div class="col-sm-8">
                        <input type="text" name="puesto__contacto[]" class="form-control-plaintext" value="{{$cliente->contactos[0]->puesto??''}}" placeholder="">
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Nombre del contacto: </label>
                      <div class="col-sm-8">
                        <input type="text" name="nombre_contacto[]" class="form-control-plaintext" value="{{$cliente->contactos[1]->nombre_contacto??''}}" placeholder="">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Celular contacto</label>
                      <div class="col-sm-8">
                        <input type="text" name="celular_contacto[]" class="form-control-plaintext" value="{{$cliente->contactos[1]->celular??''}}" placeholder="">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Correo electrónico</label>
                      <div class="col-sm-8">
                        <input type="text" name="correo_electronico_contacto[]" class="form-control-plaintext" value="{{$cliente->contactos[1]->correo_electronico??''}}" placeholder="">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Puesto de trabajo</label>
                      <div class="col-sm-8">
                        <input type="text" name="puesto__contacto[]" class="form-control-plaintext" value="{{$cliente->contactos[1]->puesto??''}}" placeholder="">
                      </div>
                    </div>
                    
                  </div>
                </div>
                
              </div>
              <div class="tab-pane fade" id="a2">
                <div class="row">
                  <div class="col-md-12">
                    <div class="form-group row">
                      <label for="" class="col-sm-12 col-form-label">Observaciones</label>
                      <div class="col-sm-12">
                        <textarea name="" id=""  class="form-control-plaintext" cols="30" rows="5"></textarea>
                      </div>
                    </div>
                  </div>
                </div>
                
              </div>
              <div class="tab-pane fade" id="a3">
                <div class="row">
                  
                  <div class="col-md-6">
                    <br>
                    <h4>Operaciones</h4>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Rutas</label>
                      <div class="col-sm-8">
                        <div class="form-check">
                          <input class="form-check-input" type="checkbox" value="" id="defaultCheck1">
                          <label class="form-check-label" for="defaultCheck1">
                            Fabricar
                          </label>
                        </div>
                        <div class="form-check">
                          <input class="form-check-input" type="checkbox" value="" id="defaultCheck1">
                          <label class="form-check-label" for="defaultCheck1">
                            Bajo pedido
                          </label>
                        </div>
                        <div class="form-check">
                          <input class="form-check-input" type="checkbox" value="" id="defaultCheck1">
                          <label class="form-check-label" for="defaultCheck1">
                            Comprar
                          </label>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <br>
                    <h4>Trazabilidad</h4>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Seguimiento</label>
                      <div class="col-sm-8">
                        <div class="form-check">
                          <input class="form-check-input" type="checkbox" value="" id="defaultCheck1">
                          <label class="form-check-label" for="defaultCheck1">
                            Por número de serie único
                          </label>
                        </div>
                        <div class="form-check">
                          <input class="form-check-input" type="checkbox" value="" id="defaultCheck1">
                          <label class="form-check-label" for="defaultCheck1">
                            Por lotes
                          </label>
                        </div>
                        <div class="form-check">
                          <input class="form-check-input" type="checkbox" value="" id="defaultCheck1">
                          <label class="form-check-label" for="defaultCheck1">
                            Sin seguimiento
                          </label>
                        </div>
                      </div>
                  </div>
                </div>
              </div>
            </div>
        </div>
      </form>

    </div>
  </div>
</div>
<script>
  function nuevaFila(){
    var row = document.getElementsByClassName("producto"); // find row to copy
    console.log(row);
    var table = document.getElementById("contenedorProductos"); // find table to append to
    var clone = row[0].cloneNode(true); // copy children too
    table.appendChild(clone); // add new row to end of table
  }
  $("input.nit").bind('keypress', function(event) {
  var regex = new RegExp("^[a-zA-Z0-9 ]+$");
  var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
  if (!regex.test(key)) {
    event.preventDefault();
    return false;
 }
});
</script>
@endsection
