@extends('layouts.app')

@section('content')
    @extends('ventas.menu')
    <style>
        .colorRojoN {
            color: red;
        }

        .fa-check-square {
            color: #fff !important;
        }

        #example a {
            color: #000 !important;
        }

        #example td {
            color: #000 !important;
        }
    </style>
    @php
        $usuario = Auth::user();
    @endphp
    <div id="contenedor-dashboard" class="container-fluid">
        <div class="row ">
            <div class="col-md-12">
                <h2>Cotizaciones</h2>
                <a type="button" href="{{ route('ventas.cotizacion') }}" class="botonColor">Nueva</a>
                @if (in_array($usuario->id, [7, 12]))
                    <a type="button" href="{{ route('ventas.dashboard') }}" class="btn btn-success">Vista
                        Ejecutivo</a>
                @endif
            </div>
        </div>
        <div class="col-md-12">
            <br>
            <br>
            <table id="example" class="display cG" style="width:100%">
                <thead>
                    <tr>
                        <td>CO</td>
                        <td>Fecha de cotización</td>
                        <td>Cliente</td>
                        <td>Cantidad</td>
                        <td>Producto</td>
                        <td>Usuario</td>
                        <td>Total</td>
                        <td>Validez</td>
                        <td>Status</td>
                    </tr>
                </thead>
                <tbody>
                    <?php $idCotizacion = 0; ?>
                    @foreach ($cotizaciones as $cotizacion)
                        <?php
                        //dd($cotizacion);
                        if ($idCotizacion != $cotizacion->id) {
                            $idCotizacion = $cotizacion->id;
                            $contador = 0;
                        }
                        $contador++;
                        ?>
                        <tr data-id="{{ $cotizacion->idCotizacionProducto }}" class="bg-warning">
                            <td class='colorRojoN'>{{ $cotizacion->idCotizacionProducto }}</td>
                            <td>{{ date('d/m/Y h:i:s', strtotime($cotizacion->created_at)) }}</td>
                            <td><a
                                    href="{{ route('ventas.ok_cotizacion', $cotizacion->idCotizacionProducto) }}">{{ $cotizacion->nombreCliente }}</a>
                            </td>
                            <td>{{ $cotizacion->cantidad }} {{ $cotizacion->nombreMedida }}</td>
                            <td>{{ $cotizacion->nombreProducto }}</td>
                            <td>{{ $cotizacion->nombreEjecutivo }}</td>
                            <td>Q {{ number_format($cotizacion->cantidad * $cotizacion->precio, 2, '.', '') }}</td>
                            <td>{{ date('d/m/Y', strtotime($cotizacion->validez_cotizacion)) }}</td>
                            <td>En aprobación</td>
                        </tr>
                    @endforeach
                    <?php $idCotizacion = 0; ?>
                    @foreach ($cotizaciones2 as $cotizacion)
                        <?php
                        //dd($cotizacion);
                        if ($idCotizacion != $cotizacion->id) {
                            $idCotizacion = $cotizacion->id;
                            $contador = 0;
                        }
                        $contador++;
                        ?>
                        <tr class="bg-success" data-id="{{ $cotizacion->idCotizacionProducto }}">
                            <td class='idOksuccess'>{{ $cotizacion->idCotizacionProducto }}</td>
                            <td>{{ date('d/m/Y h:i:s', strtotime($cotizacion->created_at)) }}</td>
                            <td><a
                                    href="{{ route('ventas.ok_cotizacion', $cotizacion->idCotizacionProducto) }}">{{ $cotizacion->nombreCliente }}</a>
                            </td>
                            <td>{{ $cotizacion->cantidad }} {{ $cotizacion->nombreMedida }}</td>
                            <td>{{ $cotizacion->nombreProducto }}</td>
                            <td>{{ $cotizacion->nombreEjecutivo }}</td>
                            <td>Q {{ number_format($cotizacion->cantidad * $cotizacion->precio, 2, '.', '') }}</td>
                            <td>{{ date('d/m/Y', strtotime($cotizacion->validez_cotizacion)) }}</td>
                            <td>Pendiente enviar</td>
                        </tr>
                    @endforeach
                    <?php $idCotizacion = 0; ?>
                    @foreach ($cotizaciones4 as $cotizacion)
                        <?php
                        //dd($cotizacion);
                        if ($idCotizacion != $cotizacion->id) {
                            $idCotizacion = $cotizacion->id;
                            $contador = 0;
                        }
                        $contador++;
                        ?>
                        <tr class="bg-success" data-id="{{ $cotizacion->idCotizacionProducto }}">
                            <td class='idOkprimary'>{{ $cotizacion->idCotizacionProducto }}</td>
                            <td>{{ date('d/m/Y h:i:s', strtotime($cotizacion->created_at)) }}</td>
                            <td><a href="{{ asset('/cotizaciones/CO_' . $cotizacion->idCotizacionProducto . '.pdf') }}"
                                    target='_blank'>{{ $cotizacion->nombreCliente }}</a></td>
                            <td>{{ $cotizacion->cantidad }} {{ $cotizacion->nombreMedida }}</td>
                            <td>{{ $cotizacion->nombreProducto }}</td>
                            <td>{{ $cotizacion->nombreEjecutivo }}</td>
                            <td>Q {{ number_format($cotizacion->cantidad * $cotizacion->precio, 2, '.', '') }}</td>
                            <td>{{ date('d/m/Y', strtotime($cotizacion->validez_cotizacion)) }}</td>
                            <td>Cliente</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    <script>
        function archivar() {
            document.querySelectorAll('.form-check-input').forEach(element => {
                var padre = element.parentElement.parentElement.parentElement;
                var idCotizacionProducto = padre.getAttribute('data-id');
                if (element.checked) {
                    jQuery(document).ready(function() {
                        var token = '{{ csrf_token() }}';
                        $.ajax({
                            type: 'POST',
                            url: '{{ route('ventas.archivar_cotizacion') }}',
                            headers: {
                                'X-CSRF-TOKEN': token
                            },
                            data: {
                                idCotizacionProducto: idCotizacionProducto,
                            },
                            success: function(data) {
                                if (data) {
                                    padre.remove();
                                    Swal.fire({
                                        position: 'top-end',
                                        title: "Cotización archivada",
                                        showConfirmButton: false,
                                        timer: 1500
                                    });
                                }
                            }
                        });
                    });
                }
            });
        }

        function produccion() {
            document.querySelectorAll('.form-check-input').forEach(element => {
                var padre = element.parentElement.parentElement.parentElement;
                var idCotizacionProducto = padre.getAttribute('data-id');
                if (element.checked) {
                    jQuery(document).ready(function() {
                        var token = '{{ csrf_token() }}';
                        $.ajax({
                            type: 'POST',
                            url: '{{ route('ventas.cotizacion_produccion') }}',
                            headers: {
                                'X-CSRF-TOKEN': token
                            },
                            data: {
                                idCotizacionProducto: idCotizacionProducto,
                            },
                            success: function(data) {
                                if (data) {
                                    padre.remove();
                                    Swal.fire({
                                        position: 'top-end',
                                        title: "Cotización enviada aprobación de producción",
                                        showConfirmButton: false,
                                        timer: 1500
                                    });
                                }
                            }
                        });
                    });
                }
            });
        }
    </script>
@endsection
