<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\InventarioController;
use App\Http\Controllers\ArchivoReporteController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('auth.login');
});

Auth::routes();

Route::get('/dashboard', 'HomeController@index')->name('home');

Route::get('enviar_correo', 'CronJobController@enviar_correo')->name('ventas.enviar_correo');
Route::get('enviar_correo2', 'CronJobController@enviar_correo2')->name('ventas.enviar_correo2');
Route::get('enviar_correo3', 'CronJobController@enviar_correo3')->name('ventas.enviar_correo3');
Route::get('enviar_correo4', 'CronJobController@enviar_correo4')->name('ventas.enviar_correo4');
Route::get('enviar_correo5', 'CronJobController@enviar_correo5')->name('ventas.enviar_correo5');
Route::get('enviar_correo6', 'CronJobController@enviar_correo6')->name('ventas.enviar_correo6');

Route::group(['prefix' => 'ventas'], function () {
    //Cotizaciones
    Route::get('dashboard', 'VentasController@index')->name('ventas.dashboard');
    Route::get('dashboard_gerencia', 'VentasController@dashboardCotizacionesG')->name('ventas.dashboard_gerencia');
    Route::get('cotizacion', 'VentasController@nueva_cotizacion')->name('ventas.cotizacion');
    Route::post('guardar_cotizacion', 'VentasController@guardar_cotizacion')->name('ventas.guardar_cotizacion');
    Route::post('archivar_cotizacion', 'VentasController@archivar_cotizacion')->name('ventas.archivar_cotizacion');
    Route::post('anular_cotizacion', 'VentasController@anular_cotizacion')->name('ventas.anular_cotizacion');
    Route::post('cotizacion_produccion', 'VentasController@cotizacion_produccion')->name('ventas.cotizacion_produccion');
    Route::post('actualizar_comentario_cotizacion', 'VentasController@actualizarComentarioCotizacion')->name('ventas.actualizar_comentario_cotizacion');
    Route::get('cotizacion_archivadas', 'VentasController@cotizacion_archivadas')->name('ventas.cotizacion_archivadas');
    Route::get('editar_cotizacion/{idCotizacion}', 'VentasController@editarCotizacion')->name('ventas.editar_cotizacion');
    Route::get('restablecer_cotizacion/{idCotizacion}', 'VentasController@restablecerCotizacion')->name('ventas.restablecer_cotizacion');
    Route::post('guardar_cotizacion_restablecer', 'VentasController@guardar_cotizacion_restablecer')->name('ventas.guardar_cotizacion_restablecer');
    Route::get('cotizacion_ok/{idCotizacion}', 'VentasController@okCotizacion')->name('ventas.ok_cotizacion');
    Route::get('cotizacion_enviar/{idCotizacion}', 'VentasController@cotizacionEnviar')->name('ventas.cotizacion_enviar');
    Route::post('cotizacion_ok2', 'VentasController@okCotizacion2')->name('ventas.ok_cotizacion2');
    Route::post('cotizacion_ok3', 'VentasController@okCotizacion3')->name('ventas.ok_cotizacion3');
    Route::post('actualizar_cotizacion/{idCotizacion}', 'VentasController@actualizarCotizacion')->name('ventas.actualizar_cotizacion');
    Route::get('cotizacion_pdf', 'VentasController@cotizacionPdf')->name('ventas.cotizacion_pdf');
    Route::get('buscar_producto', 'VentasController@buscarProducto')->name('ventas.buscar_producto');
    Route::get('buscar_producto_prima', 'VentasController@buscarProductoPrima')->name('ventas.buscar_producto_prima');

    // MENSAJE FACTURACION DESDE COTIZACION
    Route::post('mensaje_facturacion', 'VentasController@mensajeFacturacion')->name('ventas.mensaje_facturacion');

    // ------------------------------
    //Ventas
    Route::get('dashboard_pedidos', 'VentasController@dashboardPedidos')->name('ventas.dashboard_pedidos');
    Route::get('pedidos_venta', 'VentasController@pedidoVenta')->name('ventas.pedido_venta');
    Route::get('dashboard_facturar', 'VentasController@dashboardFacturar')->name('ventas.dashboard_facturar');
    Route::get('pedidos_facturar', 'VentasController@pedidoFacturar')->name('ventas.pedido_facturar');
    Route::get('dashboard_produccion', 'VentasController@dashboardOrdenProduccion')->name('ventas.dashboard_produccion');
    Route::get('dashboard_produccion_gerencia', 'VentasController@dashboardOrdenProduccionGerencia')->name('ventas.dashboard_produccion_gerencia');
    Route::get('orden_produccion/{idCotizacionProducto}', 'VentasController@ordenProduccion')->name('ventas.orden_produccion');

    //Orden Produccion
    Route::get('nueva_op', 'VentasController@nuevaOP')->name('ventas.nueva_op');
    Route::post('guardar_op', 'VentasController@guardarOP')->name('ventas.guardar_op');
    Route::get('aprobar_op/{idOrden}', 'VentasController@aprobarOP')->name('ventas.aprobar_op');
    Route::post('orden_produccion_ok/{op}', 'VentasController@actualizarOkOP')->name('ventas.orden_produccion_ok');
    Route::post('orden_produccion_ok2/{op}', 'VentasController@actualizarOkOP2')->name('ventas.orden_produccion_ok2');
    Route::get('orden_produccion_ver/{idOrden}', 'VentasController@verOP')->name('ventas.orden_produccion_ver');
    Route::post('anular_op', 'VentasController@anularOP')->name('ventas.anular_op');
    Route::get('anular_op_gerencia/{idOrden}', 'VentasController@anularOPG')->name('ventas.anular_op_gerencia');
    //Productos
    Route::get('dashboard_productos', 'VentasController@dashboardProducto')->name('ventas.dashboard_producto');
    Route::get('producto', 'VentasController@producto')->name('ventas.producto');
    Route::post('guardar_producto', 'VentasController@guardar_producto')->name('ventas.guardar_producto');
    Route::post('buscar_producto', 'VentasController@buscar_producto')->name('ventas.buscar_producto');
    Route::get('editar_producto/{idProducto}', 'VentasController@editarProducto')->name('ventas.editar_producto');
    Route::post('actualizar_producto/{producto}', 'VentasController@actualizarProducto')->name('ventas.actualizar_producto');
    Route::get('eliminar_producto/{id}', 'VentasController@eliminarProducto')->name('ventas.eliminar_producto');
    //
    Route::get('productos_tipos', 'VentasController@productoTipos')->name('ventas.productos_tipos');
    Route::get('productos_tipos_nuevo', 'VentasController@productoTiposNuevo')->name('ventas.productos_tipos_nuevo');
    Route::post('productos_tipos_guardar', 'VentasController@productoTiposGuardar')->name('ventas.productos_tipos_guardar');
    Route::get('productos_tipos_eliminar/{id}', 'VentasController@productoTiposEliminar')->name('ventas.productos_tipos_eliminar');
    //
    Route::get('productos_categorias', 'VentasController@productoCategorias')->name('ventas.productos_categorias');
    Route::get('productos_categorias_nuevo', 'VentasController@productoCategoriasNuevo')->name('ventas.productos_categorias_nuevo');
    Route::post('productos_categorias_guardar', 'VentasController@productoCategoriasGuardar')->name('ventas.productos_categorias_guardar');
    Route::get('productos_categorias_eliminar/{id}', 'VentasController@productoCategoriasEliminar')->name('ventas.productos_categorias_eliminar');
    //
    Route::get('productos_medidas', 'VentasController@productoMedidas')->name('ventas.productos_medidas');
    Route::get('productos_medidas_nuevo', 'VentasController@productoMedidasNuevo')->name('ventas.productos_medidas_nuevo');
    Route::post('productos_medidas_guardar', 'VentasController@productoMedidasGuardar')->name('ventas.productos_medidas_guardar');
    Route::get('productos_medidas_eliminar/{id}', 'VentasController@productoMedidasEliminar')->name('ventas.productos_medidas_eliminar');
    //Clientes
    Route::get('dashboard_clientes', 'VentasController@dashboardClientes')->name('ventas.dashboard_clientes');
    Route::get('cliente', 'VentasController@cliente')->name('ventas.cliente');
    Route::post('guardar_cliente', 'VentasController@guardar_cliente')->name('ventas.guardar_cliente');
    Route::post('buscar_cliente', 'VentasController@buscar_cliente')->name('ventas.buscar_cliente');
    Route::get('editar_cliente/{idCliente}', 'VentasController@editarCliente')->name('ventas.editar_cliente');
    Route::post('actualizar_cliente/{cliente}', 'VentasController@actualizarCliente')->name('ventas.actualizar_cliente');
    Route::get('eliminar_cliente/{id}', 'VentasController@eliminarCliente')->name('ventas.eliminar_cliente');
});

Route::group(['prefix' => 'compras'], function () {
    Route::get('dashboard', 'ComprasController@index')->name('compras.dashboard');
    Route::get('local', 'ComprasController@comprasLocales')->name('compras.locales');
    Route::get('local/nueva', 'ComprasController@nuevaCompraLocal')->name('compras.locales.nueva');
    Route::post('local/nueva', 'ComprasController@guardarCompraLocal')->name('compras.locales.nueva');
    // Descargar Documento de compra local
    Route::get('local/descargar/{compra_id}', 'ComprasController@descargarCompraLocal')->name('compras.locales.descargar');
    Route::get('local/detalle/{compra_id}', 'ComprasController@verCompraLocal')->name('compras.locales.detalle');
    Route::get('orden_compra', 'ComprasController@ordenCompra')->name('compras.orden_compra');
    Route::get('nueva_importacion', 'ComprasController@nueva_importacion')->name('compras.nueva_importacion');
    Route::post('guardar_importacion', 'ComprasController@guardar_importacion')->name('compras.guardar_importacion');
    Route::post('actualizar_importacion', 'ComprasController@actualizar_importacion')->name('compras.actualizar_importacion');
    Route::put('actualizar_eta', 'ComprasController@actualizar_eta')->name('compras.actualizar_eta');
    Route::post('registrar_pago', 'ComprasController@registrar_pago')->name('compras.registrar_pago');
    Route::post('editar_pago', 'ComprasController@editar_pago')->name('compras.editar_pago');
    Route::post('eliminar_pago', 'ComprasController@eliminar_pago')->name('compras.eliminar_pago');
    Route::post('buscar_proveedor', 'ComprasController@buscar_proveedor')->name('compras.buscar_proveedor');
    Route::get('buscar_producto', 'ComprasController@buscarProducto')->name('compras.buscar_producto');
    Route::get('detalle/{compra_id}', 'ComprasController@detalle')->name('compras.detalle');
    //
    // Compras locales cotizacion
    Route::post('/locales/upload/{id}', 'ComprasController@uploadCotizacion')->name('compras.locales.upload');

    //
    Route::post('pagos/{id}/eliminar-archivos', 'ComprasController@eliminarArchivos')->name('pagos.eliminar_archivos');

    Route::get('dashboard_proveedor', 'ComprasController@dashboardProveedor')->name('compras.dashboard_proveedor');
    Route::get('nuevo_proveedor', 'ComprasController@nuevoProveedor')->name('compras.nuevo_proveedor');
    Route::post('guardar_proveedor', 'ComprasController@guardar_proveedor')->name('compras.guardar_proveedor');
    Route::get('editar_proveedor/{idProveedor}', 'ComprasController@editarProveedor')->name('compras.editar_proveedor');
    Route::post('actualizar_proveedor/{idProveedor}', 'ComprasController@actualizarProveedor')->name('compras.actualizar_proveedor');
    Route::get('eliminar_proveedor/{id}', 'ComprasController@eliminarProveedor')->name('compras.eliminar_proveedor');
});


Route::group(['prefix' => 'inventario'], function () {
    Route::get('dashboard', 'InventarioController@index')->name('inventario.dashboard');
    Route::get('dashboard_salida', 'InventarioController@salidaAlamacen')->name('inventario.dashboard_salida');
    Route::post('archivar_salida', 'InventarioController@archivarSalida')->name('inventario.archivar_salida');
    Route::get('historial_despacho', 'InventarioController@HistorialDespacho')->name('inventario.historial_despacho');
    Route::post('reverse_envio', 'InventarioController@reverseEnvio')->name('inventario.reverse_envio');
    Route::get('archivar_muestra/{idEnvio}', 'InventarioController@archivarMuestra')->name('inventario.archivar_muestra');

    Route::get('dashboard_envios', 'InventarioController@enviosAlamacen')->name('inventario.dashboard_envios');
    Route::get('dashboard_archivo', 'InventarioController@dashboardArchivo')->name('inventario.dashboard_archivo');
    Route::get('dashboard_inventario', 'InventarioController@dashboardInventario')->name('inventario.dashboard_inventario');
    Route::get('dashboard_inventario_materia_prima', 'InventarioController@dashboardInventarioMateriaPrima')->name('inventario.dashboard_inventario_materia_prima');
    Route::get('dashboard_inventario_materia_prima_salidas', 'InventarioController@dashboardInventarioMateriaPrimaSalidas')->name('inventario.dashboard_inventario_materia_prima_salidas');
    Route::get('op_ok/{ordenProduccionP}', 'InventarioController@ordenProduccionRecibido')->name('inventario.op_ok');
    Route::post('ingreso_almacen', 'InventarioController@ingresoAlmacen')->name('inventario.ingreso_almacen');
    Route::post('salida_almacen_ajax', 'InventarioController@salidaAlmacenFactura')->name('inventario.salida_almacen_ajax');
    Route::post('salida_almacen_ajax_inventario', 'InventarioController@salidaAlmacenFacturaInventario')->name('inventario.salida_almacen_ajax_inventario');
    Route::post('salida_almacen_ajax_inventario_eliminar', 'InventarioController@salidaAlmacenFacturaInventarioEliminar')->name('inventario.salida_almacen_ajax_inventario_eliminar');
    Route::post('salida_almacen_inventario_ajax', 'InventarioController@salidaAlmacenInventario')->name('inventario.salida_almacen_inventario_ajax');
    Route::post('almacen_terminar_ajax', 'InventarioController@salidaAlmacenTerminar')->name('inventario.almacen_terminar_ajax');
    Route::post('almacen_terminar_inventario_ajax', 'InventarioController@salidaAlmacenInventarioTerminar')->name('inventario.almacen_terminar_inventario_ajax');
    Route::get('historial_producto/{idProducto}', 'InventarioController@historialProducto')->name('inventario.salida_almacen');
    Route::get('generar_envio/{idEnvio}', 'InventarioController@generarEnvio')->name('inventario.generar_envio');
    Route::get('ajuste_inventario', 'InventarioController@ajusteInventario')->name('inventario.ajuste_inventario');
    Route::get('ajuste_inventario_prima', 'InventarioController@ajusteInventarioPrima')->name('inventario.ajuste_inventario_prima');
    Route::post('ajuste_inventario_guardar', 'InventarioController@ajusteInventarioGuardar')->name('inventario.ajuste_inventario_guardar');
    Route::post('ajuste_inventario_prima_guardar', 'InventarioController@ajusteInventarioPrimaGuardar')->name('inventario.ajuste_inventario_prima_guardar');
    Route::post('ingreso_almacen_ajax', 'InventarioController@ingresoAlmacenAjax')->name('inventario.ingreso_almacen_ajax');
    Route::post('salida_almacen_facturacion', 'InventarioController@salidaAlmacenFacturacion')->name('inventario.salida_almacen_facturacion');
});

//Fabricacion
Route::group(['prefix' => 'fabricacion'], function () {
    Route::get('dashboard', 'FabricacionController@index')->name('fabricacion.dashboard');
    Route::get('reportes', 'FabricacionController@reporteMaquina')->name('fabricacion.reporte');
    Route::post('crear_maquina', 'FabricacionController@crearMaquina')->name('fabricacion.crear_maquina');
    Route::post('crear_reporte', 'FabricacionController@reporteMaquinas')->name('fabricacion.crear_reporte');
    Route::get('historico_reporte', 'FabricacionController@historicoReportes')->name('fabricacion.historico_reporte');
    Route::post('historico_reporte', 'FabricacionController@historicoReportesPost')->name('fabricacion.historico_reporte');
    Route::get('historico_reporte_mes', 'FabricacionController@historicoReportesMes')->name('fabricacion.historico_reporte_mes');
    Route::get('orden_produccion/{id}', 'FabricacionController@ordenProduccion')->name('fabricacion.orden_produccion');
    Route::get('orden_produccion_terminar/{id}', 'FabricacionController@ordenProduccionTerminar')->name('fabricacion.orden_produccion_terminar');
    Route::post('op_actualizar/{op}', 'FabricacionController@actualizarOP')->name('fabricacion.op_actualizar');
    Route::post('op_parcial', 'FabricacionController@parcialOP')->name('fabricacion.op_parcial');
    Route::post('op_parcial_editar', 'FabricacionController@parcialOPEditar')->name('fabricacion.op_parcial_editar');
    Route::post('op_parcial_eliminar', 'FabricacionController@eliminarEntregaParcial')->name('fabricacion.op_parcial_eliminar');
    Route::post('op_parcial_rechazar', 'FabricacionController@rechazarEntregaParcial')->name('fabricacion.op_parcial_rechazar');
    Route::post('op_parcial_actualizar', 'FabricacionController@parcialOPActualizar')->name('fabricacion.op_parcial_actualizar');
});
//Contabilidad
Route::group(['prefix' => 'contabilidad'], function () {
    Route::get('dashboard', 'ContabilidadController@index')->name('contabilidad.dashboard');
    Route::get('dashboard_solicitud_factura', 'ContabilidadController@dashBoardSolicitudFactura')->name('contabilidad.dashboard_solicitud_factura');

    //para reporte de mail
    Route::get('dashboard_solicitud_factura_reporte', 'ContabilidadController@reportePendienteFacturar')->name('contabilidad.dashboard_solicitud_factura_reporte');


    Route::post('solicitud_factura', 'ContabilidadController@solicitudFactura')->name('contabilidad.solicitud_factura');
    Route::get('factura/{idSalida}', 'ContabilidadController@factura')->name('contabilidad.factura');
    Route::get('nueva_factura', 'ContabilidadController@facturaNueva')->name('contabilidad.nueva_factura');
    Route::post('archivar_salida', 'ContabilidadController@archivarSalida')->name('contabilidad.archivar_salida');
    Route::post('crear_facturas', 'ContabilidadController@crearFacturas')->name('contabilidad.crear_facturas');
    Route::get('regresar_factura/{factura}', 'ContabilidadController@regresarFactura')->name('contabilidad.regresar_factura');
    Route::get('eliminar_factura/{factura}', 'ContabilidadController@eliminarFactura')->name('contabilidad.eliminar_factura');
    Route::post('guardar_factura', 'ContabilidadController@guardarFactura')->name('contabilidad.guardar_factura');
    Route::post('guardar_facturas', 'ContabilidadController@guardarFacturas')->name('contabilidad.guardar_facturas');
    Route::post('guardar_factura_nueva', 'ContabilidadController@guardarFacturaNueva')->name('contabilidad.guardar_factura_nueva');
    Route::get('ver_factura/{idFactura}', 'ContabilidadController@verFactura')->name('contabilidad.ver_factura');
    Route::post('editar_factura', 'ContabilidadController@editarFactura')->name('contabilidad.editar_factura');


    Route::get('reporte_ventas', 'ContabilidadController@ReporteVentasFacturas')->name('contabilidad.reporte_ventas');
    Route::post('reporte_ventas', 'ContabilidadController@ReporteVentasFacturas')->name('contabilidad.reporte_ventas');
    Route::get('dashboard_facturas_todas', 'ContabilidadController@mostrarFacturasTodas')->name('contabilidad.dashboard_facturas_todas');
    Route::get('dashboard_facturas', 'ContabilidadController@mostrarFacturas')->name('contabilidad.dashboard_facturas');
    Route::post('dashboard_facturas', 'ContabilidadController@mostrarFacturas')->name('contabilidad.dashboard_facturas');
    Route::post('nota_debito', 'ContabilidadController@notaDebito')->name('contabilidad.nota_debito');
    Route::get('dashboard_historial_facturas', 'ContabilidadController@mostrarFacturasHistorial')->name('contabilidad.dashboard_historial_facturas');
    Route::post('dashboard_historial_facturas', 'ContabilidadController@mostrarFacturasHistorial')->name('contabilidad.dashboard_historial_facturas');
    Route::get('dashboard_recibos_dia', 'ContabilidadController@mostrarRecibosDia')->name('contabilidad.dashboard_recibos_dia');

    Route::get('dashboard_recibos_mes', 'ContabilidadController@mostrarRecibosMes')->name('contabilidad.dashboard_recibos_mes');

    Route::get('dashboard_recibos', 'ContabilidadController@mostrarRecibos')->name('contabilidad.dashboard_recibos');
    Route::get('editar_recibos/{id_recibo}', 'ContabilidadController@editarRecibos')->name('contabilidad.editar_recibos');
    Route::get('imprimir_recibo/{id_recibo}', 'ContabilidadController@imprimirRecibo')->name('contabilidad.imprimir_recibo');
    Route::get('regresar_recibos/{id_recibo}', 'ContabilidadController@regresarRecibos')->name('contabilidad.regresar_recibos');
    Route::post('dashboard_recibos', 'ContabilidadController@mostrarRecibos')->name('contabilidad.dashboard_recibos');
    Route::get('recibo_caja/{idFactura}', 'ContabilidadController@reciboCaja')->name('contabilidad.recibo_caja');
    Route::post('cancelar_factura', 'ContabilidadController@cancelarFactura')->name('contabilidad.cancelar_factura');
    Route::post('recibo_caja_facturas', 'ContabilidadController@reciboCajaFactura')->name('contabilidad.recibo_caja_facturas');
    Route::post('retencion_facturas', 'ContabilidadController@retencionFactura')->name('contabilidad.retencion_facturas');
    Route::get('ver_recibo_caja/{id_recibo}', 'ContabilidadController@verReciboCaja')->name('contabilidad.ver_recibo_caja');
    Route::get('recibo_caja_facturas_nuevo', 'ContabilidadController@reciboCajaFacturaNuevo')->name('contabilidad.recibo_caja_facturas_nuevo');
    Route::post('guardar_recibo_nueva', 'ContabilidadController@guardarReciboCajaNuevo')->name('contabilidad.guardar_recibo_nueva');
    Route::post('guardar_recibo_caja', 'ContabilidadController@guardarReciboCaja')->name('contabilidad.guardar_recibo_caja');
    Route::post('guardar_retencion', 'ContabilidadController@guardarRetencion')->name('contabilidad.guardar_retencion');
    Route::post('guardar_recibo_caja_editado', 'ContabilidadController@guardarReciboCajaEditado')->name('contabilidad.guardar_recibo_caja_editado');
    Route::get('dashboard_facturas_canceladas', 'ContabilidadController@mostrarFacturasCanceladas')->name('contabilidad.dashboard_facturas_canceladas');
    Route::get('dashboard_cuenta_corriente', 'ContabilidadController@cuentaCorriente')->name('contabilidad.dashboard_cuenta_corriente');
    Route::get('ver_cuenta_corriente/{id_cliente}', 'ContabilidadController@verCuentaCorriente')->name('contabilidad.ver_cuenta_corriente');
    Route::get('ver_cuenta_corriente_info/{id_cliente}', 'ContabilidadController@verCuentaCorrienteInfo')->name('contabilidad.ver_cuenta_corriente_info');
    Route::get('imprimir_estado_cuenta/{id_cliente}', 'ContabilidadController@imprimir_estado_cuenta')->name('contabilidad.imprimir_estado_cuenta');
    Route::post('contabilidad/canceladas', 'ContabilidadController@canceladas')->name('contabilidad.canceladas');


    // Retenciones
    Route::get('dashboard_retenciones', 'ContabilidadController@mostrarRetenciones')->name('contabilidad.dashboard_retenciones');
    Route::get('regresar_retencion/{id_retencion}', 'ContabilidadController@regresarRetencion')->name('contabilidad.regresar_retencion');
    Route::get('eliminar_retencion/{id_retencion}', 'ContabilidadController@eliminarRetencion')->name('contabilidad.eliminar_retencion');

    //notas de credito y debito
    Route::get('dashboard_notas_credito_debito', 'ContabilidadController@mostrarNotaDebito')->name('contabilidad.dashboard_notas_credito_debito');
    Route::get('editar_notas/{id_nota}', 'ContabilidadController@editarNotas')->name('contabilidad.editar_notas');
    Route::post('editar_notas/{id_nota}', 'ContabilidadController@updateNotas')->name('contabilidad.editar_notas');
    //autorizar notas es para que aparzcan solo los datos y se le de click en aceptar
    Route::post('autorizar_notas/{id_nota}', 'ContabilidadController@autorizarNotas')->name('contabilidad.autorizar_notas');
    Route::post('rechazar_notas/{id_nota}', 'ContabilidadController@rechazarNotas')->name('contabilidad.rechazar_notas');

    //para visualizar la nota
    Route::get('autorizar_notas/{id_nota}', 'ContabilidadController@verAutorizarNotas')->name('contabilidad.autorizar_notas');

    Route::get('regresar_notas/{id_nota}', 'ContabilidadController@regresarNotas')->name('contabilidad.regresar_notas');
    Route::get('imprimir_nota/{id_nota}', 'ContabilidadController@imprimirNota')->name('contabilidad.imprimir_nota');
});


//Ajustes
Route::group(['prefix' => 'ajustes'], function () {
    Route::get('dashboard', 'AjustesController@index')->name('ajustes.dashboard');
    Route::post('categorias', 'AjustesController@storeOrUpdate')->name('ajustes.categorias.storeOrUpdate');
    Route::post('guardar_ajustes', 'AjustesController@guardarAjustes')->name('ajustes.guardar_ajustes');
});



//reportes
Route::group(['prefix' => 'reportes'], function () {
    Route::get('dashboard', 'ReportesController@mostrarFacturasTodas')->name('reportes.dashboard');
    Route::get('dashboard/gerencia', 'ReportesController@reportesGerencia')->name('reportes.dashboard_gerencia');
    Route::get('dashboard/gerencia/producto-terminado', 'ReportesController@reportesGerenciaProductoTerminado')->name('reportes.producto_terminado');
    Route::post('dashboard', 'ReportesController@mostrarFacturasFiltro')->name('reportes.dashboard');
    Route::get('dashboard_facturas_dia', 'ReportesController@mostrarFacturasDia')->name('reportes.ventas_dia');
    Route::get('dashboard_facturas_mes', 'ReportesController@mostrarFacturasMes')->name('reportes.ventas_mes');
    Route::get('recibos_mes', 'ReportesController@mostrarRecibosMes')->name('reportes.dashboard_recibos_mes');
    Route::get('recibos_diario', 'ReportesController@mostrarRecibosDia')->name('reportes.dashboard_recibos_diario');
    Route::get('recibos_anio', 'ReportesController@mostrarRecibosAnio')->name('reportes.dashboard_recibos_anio');

    // Libro de ventas
    Route::get('libro_ventas', 'ReportesController@libroVentas')->name('reportes.libro_ventas');
    // Libro de ventas post para recibir fecha_inicio y fecha_fin
    Route::post('libro_ventas', 'ReportesController@libroVentas')->name('reportes.libro_ventas');


    // Reportes de notas de credito y debito
    // Reporte de cliente especial Luis Gutierrez
    Route::get('reporte/notas/cliente-especial', 'ReportesController@reporteClienteEspecial')->name('reportes.reporte_cliente_especial');
    Route::post('reporte/notas/cliente-especial', 'ReportesController@reporteClienteEspecial')->name('reportes.reporte_cliente_especial');


    // ARCHIVOS DE REPORTES
    Route::get('/files', [ArchivoReporteController::class, 'index'])->name('files.index');
    Route::post('/files/upload', [ArchivoReporteController::class, 'upload'])->name('files.upload');
    Route::delete('/files/{id}', [ArchivoReporteController::class, 'delete'])->name('files.delete');
    Route::post('/files/replace/{id}', [ArchivoReporteController::class, 'replace'])->name('files.replace');


    // Consultas de inventario
    Route::post('/historial', [InventarioController::class, 'inventarioHistorial'])->name('inventario.inventario_historial');

    Route::get('/demanda/detalle', [InventarioController::class, 'inventarioDemandaDetalle'])->name('inventario.demanda_detalle');
    Route::get('/detalle', [InventarioController::class, 'inventarioDetalle'])->name('inventario.detalle');

    // Importaciones
    Route::get('/importaciones', [ArchivoReporteController::class, 'importaciones'])->name('reportes.importaciones');
    Route::get('/importaciones/detalle/{compra_id}',  [ArchivoReporteController::class, 'detalleImportaciones'])->name('reportes.importaciones.detalle');
});

//recursos humanos
Route::group(['prefix' => 'rrhh'], function () {
    Route::get('dashboard', 'ContabilidadController@dashboardHumanos')->name('rrhh.dashboard');
    Route::post('dashboard', 'ContabilidadController@dashboardHumanosFecha')->name('rrhh.dashboard_fecha');
    Route::get('usuarios', 'UserController@index')->name('rrhh.usuarios');
    Route::get('usuarios_editar/{id}', 'UserController@show')->name('rrhh.usuarios_editar');
    Route::post('usuarios_editar', 'UserController@edit')->name('rrhh.usuarios_edit');
    Route::get('comisiones_por_usuario/{id}', 'ContabilidadController@comisionesPorUsuario')->name('rrhh.comisiones_por_usuario');
    Route::post('comisiones_por_fecha', 'ContabilidadController@comisionesPorUsuarioMes')->name('rrhh.comisiones_por_usuario_fecha');
});
