<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Facturas extends Model
{
    //
    use SoftDeletes;
    protected $table = 'facturas';

    public function cliente()
    {
        return $this->hasOne('App\Cliente', 'id', 'id_cliente')->with('info_ejecutivo');
    }
    public function producto()
    {
        return $this->hasOne('App\Producto', 'id', 'id_producto')->with('medida');
    }
    public function recibo_caja()
    {
        return $this->hasOne('App\ReciboCaja', 'id', 'id_recibo_caja_factura');
    }
    public function nota()
    {
        return $this->hasOne('App\NotaDebito', 'id', 'id_debito');
    }

    // Función para devolver el estado como un objeto con estado y color
    public function estadoString(): object
    {
        $estado = new \stdClass();

        if ($this->deleted_at) {
            $estado->estado = 'Anulada';
            $estado->color = 'text-danger'; // Clase CSS para el color gris
            return $estado;
        }

        if ($this->estatus == 2) {
            $estado->estado = 'Cancelada';
            $estado->color = 'text-success'; // Clase CSS para el color rojo
            return $estado;
        }

        if ($this->id_recibo_caja_factura == 0 && $this->abono == 0) {
            $estado->estado = 'Pendiente de Pago';
            $estado->color = 'text-gray'; // Clase CSS para el color amarillo
            return $estado;
        }

        $estado->estado = 'Pagada parcialmente';
        $estado->color = 'text-primary'; // Clase CSS para el color verde
        return $estado;
    }

    // Relacion muchos a muchos con retencion a traves del modelo pivote RetencionFactura
    public function retenciones()
    {
        return $this->belongsToMany('App\Retencion', 'retencion_facturas', 'factura_id', 'retencion_id')->withPivot('monto');
    }

    public function retencionesAsignadas()
    {
        return $this->hasMany('App\RetencionFactura', 'factura_id', 'id');
    }

    public function retencionAplicada($retencion_id)
    {
        return $this->retencionesAsignadas()->where('retencion_id', $retencion_id)->first();
    }

    // Nuevo manejo de notas de Debito/Credito
    public function notaDebito()
    {
        return $this->hasMany('App\NotaDebito', 'id_factura', 'id')->where('id_tipo', 1);
    }

    public function notaCredito()
    {
        return $this->hasMany('App\NotaDebito', 'id_factura', 'id')->where('id_tipo', 2);
    }
}
