<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class IngresoAlmacen extends Model
{
    //
    use SoftDeletes;
    protected $table = 'orden_ingreso_almacen';

    public function cliente()
    {
        return $this->hasOne('App\Cliente', 'id', 'id_cliente')->with('info_ejecutivo');
    }
    public function producto()
    {
        return $this->hasOne('App\Producto', 'id', 'id_producto')->with('medida');
    }
    public function op()
    {
        return $this->hasOne('App\OrdenProduccion', 'id', 'id_op')->with('almacen_inventario');
    }

    public function productoCotizacion(){
        return $this->hasOne('App\CotizacionProductos', 'id', 'id_cotizacion_producto');
    }

    // Funcion auxiliar para obtener el nombre de su archivo cotizacion pdf
    public function getCotizacionPdfAttribute()
    {
        return "CO_" . $this->id_cotizacion_producto . ".pdf";
    }
}
