<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
    
class ReciboCaja extends Model
{

    use SoftDeletes;
    protected $table = 'recibo_caja';

    public function cliente(){
        return $this->hasOne('App\Cliente', 'id', 'id_cliente')->with('info_ejecutivo');
    }
    public function facturas(){
        return $this->hasMany('App\ReciboCajaFactura', 'id_recibo_caja', 'id')->with('ver_factura');
    }
}
