<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>CUENTA PDF</title>
</head>
<style>
    #logo {
        width: 110px;
    }

    .tituloH {
        position: absolute;
        right: 30px;
    }

    .color_verde {
        background-color: #04903a;
        color: #fff;
    }

    body {
        font-size: 10px;
    }

    #example2 td {
        text-align: right;
    }

    .central_f {
        text-align: center;
    }
</style>

<body>
    <div id="contenedor-dashboard" class="container-fluid">
        @if (!$clientes)

            <div class="row ">

                <div class="col-md-12">
                    <h2>Cuenta Corriente {{ $cliente_info->nombre }} - Sin saldo</h2>
                </div>
            </div>
            <div class="col-md-12">
                <br>
                <table id="example2" class="display" style="width:100%">
                    <thead>
                        <tr class="color_verde">
                            <th scope="col">Fecha</th>
                            <th scope="col">Factura</th>
                            <th scope="col">TOTAL</th>
                            <th scope="col">0 - 30 días</th>
                            <th scope="col">31 - 60 días</th>
                            <th scope="col">61 - 90 días</th>
                            <th scope="col">+90 días</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                    </tbody>
                </table>
            </div>
    </div>
@endsection
@else
<div class="row ">
    <div class="col-md-12">
        <img id="logo" src="https://laravelrp.com/public/images/logo_concisa.png" alt="Concisa"
            class="img-fluid">
        <p class="tituloH"> Guatemala, {{ date('d') }}/{{ date('m') }}/{{ date('Y') }} </p>
        <p class="central_f"><strong>ESTADO DE CUENTA</strong></p>
        <h2>Señores: <br> {{ $clientes->nombre }} - Q {{ number_format($total_cliente, 2, '.', ',') }}</h2>
    </div>
</div>
<table id="example2" class="display" style="width:100%">
    <thead>
        <tr class="color_verde">
            <th scope="col">Fecha</th>
            <th scope="col">Factura</th>
            <th scope="col">TOTAL</th>
            <th scope="col">Vigente</th>
            <th scope="col">+30 días</th>
            <th scope="col">+60 días</th>
            <th scope="col">+90 días</th>
        </tr>
    </thead>
    <tbody>
        {{-- Mostrar facturas vigentes --}}
        @if ($vigente_clientes)
            @foreach ($vigente_clientes as $factura)
                <tr>
                    <td>{{ date('d/m/Y', strtotime($factura->created_at)) }}</td>
                    <td>{{ $factura->no_sat }}</td>
                    <td>{{ number_format($vigente_clientes_total[$factura->no_sat] ?? 0, 2, '.', ',') }}</td>
                    <td>{{ number_format($vigente_clientes_total[$factura->no_sat] ?? 0, 2, '.', ',') }}</td>
                    <td></td>
                    <td></td>
                    <td></td>
                </tr>
            @endforeach
        @endif
        @if ($facturas[30] ?? 0)
            @foreach ($facturas[30] as $factura)
                <tr>
                    <td>{{ date('d/m/Y', strtotime($factura->created_at)) }}</td>
                    <td>{{ $factura->no_sat }}</td>
                    <td>{{ number_format($total_cliente_dias[30][$factura->no_sat] ?? 0, 2, '.', ',') }}</td>
                    <td></td>
                    <td>{{ number_format($total_cliente_dias[30][$factura->no_sat] ?? 0, 2, '.', ',') }}</td>
                    <td></td>
                    <td></td>
                </tr>
            @endforeach
        @endif
        @if ($facturas[60] ?? 0)
            @foreach ($facturas[60] as $factura)
                <tr>
                    <td>{{ date('d/m/Y', strtotime($factura->created_at)) }}</td>
                    <td>{{ $factura->no_sat }}</td>
                    <td>{{ number_format($total_cliente_dias[60][$factura->no_sat] ?? 0, 2, '.', ',') }}</td>
                    <td></td>
                    <td></td>
                    <td>{{ number_format($total_cliente_dias[60][$factura->no_sat] ?? 0, 2, '.', ',') }}</td>
                    <td></td>
                </tr>
            @endforeach
        @endif
        @if ($facturas[90] ?? 0)
            @foreach ($facturas[90] as $factura)
                <tr>
                    <td>{{ date('d/m/Y', strtotime($factura->created_at)) }}</td>
                    <td>{{ $factura->no_sat }}</td>
                    <td>{{ number_format($total_cliente_dias[90][$factura->no_sat] ?? 0, 2, '.', ',') }}</td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td>{{ number_format($total_cliente_dias[90][$factura->no_sat] ?? 0, 2, '.', ',') }}</td>
                </tr>
            @endforeach
        @endif
        @if ($facturas[100] ?? 0)
            @foreach ($facturas[100] ?? 0 as $factura)
                <tr>
                    <td>{{ date('d/m/Y', strtotime($factura->created_at)) }}</td>
                    <td>{{ $factura->no_sat }}</td>
                    <td>{{ number_format($total_cliente_dias[100][$factura->no_sat] ?? 0, 2, '.', ',') }}</td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td>{{ number_format($total_cliente_dias[100][$factura->no_sat] ?? 0, 2, '.', ',') }}</td>
                </tr>
            @endforeach
        @endif
        {{-- Total final --}}
        <tr id="total_final2" class="color_verde">
            <td id="total_final">TOTAL</td>
            <td></td>
            <td>{{ number_format($total_total, 2, '.', ',') }}</td>
            <td>{{ number_format($total_vigente, 2, '.', ',') }}</td>
            <td>{{ number_format($total_total30, 2, '.', ',') }}</td>
            <td>{{ number_format($total_total60, 2, '.', ',') }}</td>
            <td>{{ number_format($total_total90 + $total_total100, 2, '.', ',') }}</td>
        </tr>
    </tbody>
</table>
@endif
</div>
<div style="margin-left: 15px;font-size: 9px;margin-top:35px;">
    <ul style="line-height: -5px;">
        <li style="display:flex;">
            <p>•CC: Gerencia General</p>
        </li>
        <li style="display:flex;">
            <p>•CC: Auditoria Interna</p>
        </li>
        <li style="display:flex;">
            <p>
                •CC: Ejecutivo de Ventas - {{ $clientes?->info_ejecutivo?->name }}
            </p>
        </li>
    </ul>
</div>
</body>

</html>
