<?php

use Illuminate\Support\Carbon;
use App\Maquinas;

function formatearDosCifras($numero)
{
    // Convertir el número a una cadena y agregar un cero adelante si solo tiene una cifra
    return str_pad($numero, 2, '0', STR_PAD_LEFT);
}

function formatearTiempo($numero)
{
    // Inicializar el arreglo de resultado
    $arreglo = [
        'horas' => 0,
        'minutos' => $numero,
    ];

    // Verificar si el número es mayor o igual a 60
    if ($numero >= 60) {
        // Calcular las horas y minutos
        $arreglo['horas'] = floor($numero / 60);
        $arreglo['minutos'] = $numero % 60;
    }

    $arreglo['horas'] = intval($arreglo['horas']);
    $arreglo['minutos'] = intval($arreglo['minutos']);

    return $arreglo;
}

?>

@extends('layouts.app')
@section('content')
    @extends('fabricacion.menu')


    <div id="contenedor-dashboard" class="container-fluid">
        <div class="row ">
            <div class="col-md-12">
                <h2>Reporte diario de Producción</h2>
            </div>
        </div>
    </div>
    <div id="contenedor-dashboard" class="container-fluid">
        <div class="row ">
            <div class="col-md-3">
                <form method="POST" action="{{ route('fabricacion.historico_reporte') }}">
                    @csrf
                    <div class="input-group mb-3">
                        <input type="date" name="date" class="form-control rounded-0"
                            value="{{ \Carbon\Carbon::now()->format('Y-m-d') }}">
                        <button class="btn btn-outline-primary rounded-0" type="submit" id="button-addon2">Buscar</button>
                    </div>
                </form>
            </div>
        </div>
        <div class="col">
            <h5>Reporte de: {{ $fechaAyer }}</b></h5>
        </div>
    </div>
    </div>
    <div class="container-fluid">

        <table class="table table-bordered">
            <thead class="thead-light">
                <tr>
                    <th>Grupo</th>
                    <th>Maquina</th>
                    <th style="width: 30px;">Horas trabajadas</th>
                    <th>Descripción</th>
                    <th style="width: 20px;">Cantidad producida</th>
                    <th style="width: 20px;">Medida</th>
                    <th style="width: 40px;">Rendimiento por hora</th>
                    <th>Observación</th>
                </tr>
            </thead>
            <tbody>
                @php
                    $grupos = [
                        'CUPS' => ['HQL CUP', 'DRQ- Cups'],
                        'CAPUCHONES' => ['HQL1', 'HQL2', 'HQL3', 'HQL4', 'DRQ- Gr'],
                        'LIENZOS' => ['CONVERTIDORA 1', 'CONVERTIDORA 2'],
                    ];
                    $cantidadTotalGrupos = ['CUPS' => 0, 'CAPUCHONES' => 0, 'LIENZOS' => 0];
                    $reportesAgrupados = ['CUPS' => [], 'CAPUCHONES' => [], 'LIENZOS' => [], 'SIN GRUPO' => []];
                @endphp
                @foreach ($reportes as $reporte)
                    @php
                        $maquina = Maquinas::find($reporte->id_maquina);
                        $nombreMaquina = $maquina->maquina;
                        $grupo = null;
                        foreach ($grupos as $key => $value) {
                            if (in_array($nombreMaquina, $value)) {
                                $grupo = $key;
                                break;
                            }
                        }
                        if ($grupo === null) {
                            $grupo = 'SIN GRUPO';
                        }
                        if (isset($cantidadTotalGrupos[$grupo])) {
                            $cantidadTotalGrupos[$grupo] += $reporte->total_cantidad;
                        } else {
                            $cantidadTotalGrupos[$grupo] = $reporte->total_cantidad;
                        }
                        $reportesAgrupados[$grupo][] = $reporte;
                    @endphp
                @endforeach

                @foreach ($reportesAgrupados as $grupo => $reportes)
                    @foreach ($reportes as $reporte)
                        @php
                            $maquina = Maquinas::find($reporte->id_maquina);
                            $nombreMaquina = $maquina->maquina;
                            $rendimientoPorHora = 0;
                            if ($reporte->total_cantidad && $reporte->total_horas != 0) {
                                $rendimientoPorHora = $reporte->total_cantidad / abs($reporte->total_horas);
                            }
                        @endphp
                        <tr>
                            <td>{{ $grupo }}</td>
                            <td>{{ $nombreMaquina }}</td>
                            <td>
                                @php
                                    $resultado = formatearTiempo($reporte->total_minutos);
                                    if ($resultado['horas'] >= 1) {
                                        echo formatearDosCifras($reporte->total_horas + $resultado['horas']);
                                        echo ':';
                                        echo formatearDosCifras($resultado['minutos']);
                                    } else {
                                        echo formatearDosCifras($reporte->total_horas);
                                        echo ':';
                                        echo formatearDosCifras($resultado['minutos']);
                                    }
                                @endphp
                            </td>
                            <td>{{ $reporte->trabajo }}</td>
                            <td>{{ number_format($reporte->total_cantidad, 2, '.', ',') }}</td>
                            <td>{{ $reporte->medida }}</td>
                            <td>{{ number_format($rendimientoPorHora, 2, '.', ',') }}</td>
                            <td>{{ $reporte->observacion }}</td>
                        </tr>
                    @endforeach
                    @if ($grupo !== 'SIN GRUPO')
                        <tr style="background-color: rgb(179, 255, 179);">
                            <td colspan="4">Total {{ $grupo }}</td> 
                            <td colspan="4">{{ number_format($cantidadTotalGrupos[$grupo], 2, '.', ',') }}</td>
                        </tr>
                    @endif
                @endforeach
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="8">
                        Observaciones:
                        @if (count($reportesGeneral) == 0)
                            No hay comentarios generales
                        @else
                            {{ $reportesGeneral[0]->observacion }}
                        @endif
                    </td>
                </tr>
            </tfoot>
        </table>


    </div>
@endsection
