@extends('layouts.app')

@section('content')
@extends('fabricacion.menu')

<div id="contenedor_interno" class="container-fluid">
  <div class="row ">
    <div class="col-md-12">
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="{{ route('ventas.dashboard') }}">Ingerso a almacen</a></li>
          <li class="breadcrumb-item active" aria-current="page">Actualizar</li>
        </ol>
      </nav>
      @if($op->status!=4)
      <form action="{{ route('inventario.ingreso_almacen') }}" method="POST">
        @csrf
        <input type="submit" class="botonColor" value="Recibir" />
    </div>
    @endif
    <hr>
  </div>
</div>

<div id="contenedor_contenido" class="container-fluid px-lg-5">
<div class="row">
  <div class="col-md-12">
    <h2>Orden de Produción: OP{{$op->id}}</h2>
  </div>
  <div class="col-md-12">
   
      <div class="row">
        <div class="col-md-6">
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Cliente</label>
            <div class="col-sm-8">
              <input type="text" readonly class="form-control-plaintext" value="{{$op->cliente->nombre}}" placeholder="">
              <input type="hidden" class="form-control-plaintext" name="id_cliente" value="{{$op->id_cliente}}">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Producto</label>
            <div class="col-sm-8">
              <p>{{$op->producto->nombre}}</p>
              <input type="hidden" id="id_producto" class="form-control-plaintext" name="id_op" value="{{$opParciales->id_op}}">
              <input type="hidden" id="id_producto" class="form-control-plaintext" name="id_op_parcial" value="{{$opParciales->id}}">
              <input type="hidden" id="id_producto" class="form-control-plaintext" name="id_cotizacion" value="{{$op->id_cotizacion_producto}}">
              <input type="hidden" id="id_producto" class="form-control-plaintext" name="id_producto" value="{{$op->id_producto}}">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Cantidades recibida</label>
            <div class="col-sm-8">
              <input type="text" id="cantidad" readonly class="form-control-plaintext" name="cantidad" value="{{$opParciales->cantidad}}" placeholder="">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Unidad de medida:</label>
            <div class="col-sm-8">
            <input type="text" readonly class="form-control-plaintext" name="lista_materiales" value="{{ $op->producto->medida->nombre}}" placeholder="">
            </div>
          </div>
          <div class="form-group row bg-primary">
            <label for="" class="col-sm-4 col-form-label">Fecha recibida:</label>
            <div class="col-sm-8">
              <input type="text" readonly class="form-control-plaintext daterange-single" name="fecha_recibida" value="{{ $op->fecha_recibida ? date("d-m-Y", strtotime($op->fecha_entrega)):''}}" placeholder="">
            </div>
          </div>

          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Condiciones de entrega</label>
            <div class="col-sm-8">
              <input type="text" readonly class="form-control-plaintext" name="condiciones_entrega" value="{{$op->condiciones_entrega}}" placeholder="">
            </div>
          </div>
        </div>


        <div class="col-md-6">
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Número de cotización</label>
            <div class="col-sm-8">
              <input type="text" class="form-control-plaintext" value="CO{{$op->id_cotizacion_producto}}" placeholder="">
              <input type="hidden" name="id_cotizacion" value="{{$op->id_cotizacion}}">
              <input type="hidden" name="id_cotizacion_producto" value="{{$op->id_cotizacion_producto}}">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Número de orden compra</label>
            <div class="col-sm-8">
              <input type="text" class="form-control-plaintext" name="numero_oc" value="{{$op->numero_oc}}" placeholder="">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">kgs por Millar</label>
            <div class="col-sm-8">
              <input id="kgs_millar" name="kgs_millar" type="text" onchange="materialProcesar(this)" class="form-control-plaintext" value="{{$op->kgs_millar}}" placeholder="">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Kgs a Procesar</label>
            <div class="col-sm-8">
              <input type="text" id="kgProcesar" name="kgs_procesar" readonly class="form-control-plaintext" value="{{$op->kgs_procesar}}" placeholder="">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Micras</label>
            <div class="col-sm-8">
              <input type="text"  class="form-control-plaintext" name="micras" value="{{$op->micras}}" placeholder="">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Caracteristicas</label>
            <div class="col-sm-8">
              <input type="text"  class="form-control-plaintext" name="caracteristicas" value="{{$op->caracteristicas}}" placeholder="">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Observaciones</label>
            <div class="col-sm-8">
              <input type="text"  class="form-control-plaintext" name="observaciones" value="{{$op->observaciones}}" placeholder="">
            </div>
          </div>
        </div>
      </div>
    </form>

  </div>
  <br>
  <br><br>
  <br>

</div>
</div>

<script>
  var kgs_millar=document.getElementById('kgs_millar');
  materialProcesar(kgs_millar)

  function nuevaFila(){
    var row = document.getElementsByClassName("producto"); // find row to copy
    console.log(row);
    var table = document.getElementById("contenedorProductos"); // find table to append to
    var clone = row[0].cloneNode(true); // copy children too
    table.appendChild(clone); // add new row to end of table
  }
  function materialProcesar(element){
    
    var cantidad=document.getElementById('cantidad').value;
    var kgMillar=element.value;
    var total=parseFloat(kgMillar)*parseFloat(cantidad);
    document.getElementById('kgProcesar').value=total;
    console.log(total);
    
  }
  $('#entregaParcial').click(function(){
    var token = '{{ csrf_token() }}';
    var cantidad=$('#cantidad_parcial').val();
    var id_producto=$('#id_producto').val();
    var idOP='{{$op->id}}';
    var descripcion=$('#observacion_parcial').val();
      $.ajax({
        type:'POST',
        url:'{{ route('fabricacion.op_parcial') }}',
        headers: {'X-CSRF-TOKEN': token},
        data:{
          cantidad:cantidad,
          descripcion:descripcion,
          id_producto:id_producto,
          idOP:idOP
        },
        success:function(data){
          location.reload();
        }
      });
  });
  
 
</script>
@endsection
