@extends('layouts.app')
@extends('reportes.menu')

<style>
    .table-success {
        background-color: #063913 !important;
        color: #ffffff !important;
    }
</style>
@section('content')
    <div class="container-fluid">
        <!-- Sección de filtros -->
        <div class="card mb-4 shadow-sm">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-filter me-2"></i>
                    Filtros de Consulta
                </h5>
            </div>
            <div class="card-body bg-light">
                <form action="{{ route('reportes.reporte_cliente_especial') }}" method="POST" id="form-consulta">
                    @csrf
                    <div class="row g-3 align-items-end">
                        <div class="col-md-4">
                            <label for="fechaInicio" class="form-label fw-bold text-success">Fecha Inicio</label>
                            <input type="date" class="form-control border-success" name="fechaInicio" id="fechaInicio"
                                value="{{ request('fechaInicio') }}">
                        </div>
                        <div class="col-md-4">
                            <label for="fechaFin" class="form-label fw-bold text-success">Fecha Final</label>
                            <input type="date" class="form-control border-success" name="fechaFin" id="fechaFin"
                                value="{{ request('fechaFin') }}">
                        </div>
                        <div class="col-md-4">
                            <button type="submit" class="btn btn-success w-100">
                                <i class="fas fa-search me-2"></i>
                                Consultar
                            </button>
                        </div>
                    </div>

                    @if (isset($fechaInicioFormateada))
                        <div class="alert alert-success mt-3 d-flex align-items-center border-success">
                            <i class="fas fa-info-circle me-2"></i>
                            <span>
                                Consulta realizada del
                                <strong>{{ $fechaInicioFormateada }}</strong>
                                al
                                <strong>{{ $fechaFinFormateada }}</strong>
                            </span>
                        </div>
                    @endif
                </form>
            </div>
        </div>
        <!-- Tabla de datos -->
        <div class="card shadow-sm">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="fas fa-table me-2"></i>
                    Reporte de Notas - Luis Gutiérrez
                </h5>
            </div>
            <div class="card-body p-0 bg-white">
                <div class="table-responsive">
                    <table id="tabla-reportes" class="table table-striped table-hover table-sm mb-0">
                        <thead class="table-success">
                            <tr>
                                <th class="text-center">ID</th>
                                <th class="text-center">Fecha</th>
                                <th class="text-center">FEL Serie</th>
                                <th class="text-center">No. SAT</th>
                                {{-- <th class="text-center">Cantidad</th>
                                <th>Producto</th>
                                <th class="text-end">Precio</th> --}}
                                <th class="text-end">Valor Factura</th>
                                <th class="text-center">No.Nota Debito 40%</th>
                                <th class="text-end">Valor Nota Debito 40%</th>
                                <th class="text-center">No. NC</th>
                                <th class="text-end">Valor NC 40%</th>
                                <th class="text-end">Total Operativo</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($facturas as $operacion)
                                @php
                                    // Obtener todas las notas de débito y crédito para esta operación
                                    $notasDebito = $operacion->notaDebito ?? collect();
                                    $notasCredito = $operacion->notaCredito ?? collect();

                                    // Calcular sumas totales
                                    $totalNotasDebito = $notasDebito->sum('cantidad');
                                    $totalNotasCredito = $notasCredito->sum('cantidad');

                                    // Si total de notas de debito es 0.
                                    // Calcular como 40% del total de la factura.
                                    if ($totalNotasDebito == 0) {
                                        $totalNotasDebito = $operacion->cantidad * $operacion->precio * 0.4;
                                        $facturaCalculada = $operacion->cantidad * $operacion->precio * 0.6;
                                    } else {
                                        $facturaCalculada = $operacion->cantidad * $operacion->precio;
                                    }
                                    $saldoCalculado = $facturaCalculada + $totalNotasDebito - $totalNotasCredito;
                                @endphp
                                <tr>
                                    <td class="text-center">{{ $operacion->id }}</td>
                                    <td class="text-center">
                                        <small class="text-success fw-bold">
                                            {{ \Carbon\Carbon::parse($operacion->created_at)->format('d/m/Y') }}
                                        </small>
                                    </td>
                                    <td class="text-center">{{ $operacion->serie_sat }}</td>
                                    <td class="text-center">
                                        <a href="{{ asset('/facturas/' . $operacion->archivo_factura) }}" target='_blank'>
                                            {{ $operacion->no_sat }}
                                        </a>
                                    </td>
                                    <td class="text-end" data-valor="{{ $facturaCalculada }}">
                                        <strong class="text-primary">Q{{ number_format($facturaCalculada, 2) }}</strong>
                                    </td>
                                    <td class="text-center">
                                        <ul class="list-unstyled mb-0 small">
                                            @foreach ($notasDebito as $nota)
                                                <li>• {{ $nota->id }}</li>
                                            @endforeach
                                        </ul>
                                    </td>
                                    <td class="text-end">
                                        Q{{ number_format($totalNotasDebito, 2) }}
                                    </td>
                                    <td class="text-center">
                                        <ul class="list-unstyled mb-0 small">
                                            @foreach ($notasCredito as $nota)
                                                <li>• {{ $nota->id }}</li>
                                            @endforeach
                                        </ul>
                                    </td>
                                    <td class="text-end">
                                        Q{{ number_format($totalNotasCredito, 2) }}
                                    </td>
                                    <td class="text-end" data-saldo="{{ $saldoCalculado }}">
                                        <strong class="text-dark">Q{{ number_format($saldoCalculado, 2) }}</strong>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="13" class="text-center py-4">
                                        <div class="d-flex flex-column align-items-center text-muted">
                                            <i class="fas fa-inbox fa-3x mb-3 text-success"></i>
                                            <h5>No hay datos disponibles</h5>
                                            <p>No se encontraron registros para el período seleccionado</p>
                                        </div>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                        <tfoot class="table-success">
                            <tr>
                                <th colspan="4" class="text-end fw-bold">TOTALES:</th>
                                <th class="text-end fw-bold" id="total-factura">Q0.00</th>
                                <th class="text-center">-</th>
                                <th class="text-end fw-bold" id="total-debito">Q0.00</th>
                                <th class="text-center">-</th>
                                <th class="text-end fw-bold" id="total-credito">Q0.00</th>
                                <th class="text-end fw-bold" id="total-saldo">Q0.00</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>

        <!-- Resumen de totales -->
        <div class="row mt-4">
            <div class="col-md-12">
                <div class="card bg-light border-success">
                    <div class="card-body">
                        <h5 class="card-title text-center text-success">
                            <i class="fas fa-calculator me-2"></i>
                            Resumen Total
                        </h5>
                        <div class="row text-center">
                            <div class="col-md-3">
                                <div class="border-end border-success">
                                    <h6 class="text-muted">Total Facturas</h6>
                                    <h4 class="text-success" id="resumen-facturas">Q0.00</h4>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="border-end border-success">
                                    <h6 class="text-muted">Total Débito</h6>
                                    <h4 class="text-warning" id="resumen-debito">Q0.00</h4>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="border-end border-success">
                                    <h6 class="text-muted">Total Crédito</h6>
                                    <h4 class="text-info" id="resumen-credito">Q0.00</h4>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <h6 class="text-muted">Total Final</h6>
                                <h4 class="text-dark fw-bold" id="resumen-saldo">Q0.00</h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        // Configuración de DataTable para reporte
        const configDataTable = {
            paging: true,
            pageLength: 50,
            lengthMenu: [
                [25, 50, 100, -1],
                [25, 50, 100, "Todos"]
            ],
            order: [
                [0, "desc"]
            ],
            dom: 'Blfrtip',
            buttons: [{
                    extend: 'excel',
                    text: '<i class="fas fa-file-excel"></i> Excel',
                    className: 'btn btn-success btn-sm',
                    title: 'Reporte Notas Luis Gutierrez',
                    filename: 'reporte_notas_luis_gutierrez_' + new Date().toISOString().slice(0, 10)
                },
                {
                    extend: 'print',
                    text: '<i class="fas fa-print"></i> Imprimir',
                    className: 'btn btn-success btn-sm',
                    title: 'Reporte Notas Luis Gutierrez',
                    customize: function(win) {
                        $(win.document.body)
                            .css('font-size', '10pt')
                            .prepend(
                                '<div style="text-align:center;"><h3>Reporte de Notas - Luis Gutiérrez</h3></div>'
                            );

                        $(win.document.body).find('table')
                            .addClass('compact')
                            .css('font-size', 'inherit');
                    }
                }
            ],
            responsive: {
                details: {
                    type: 'column',
                    target: 'tr'
                }
            },
            columnDefs: [
                // Columnas siempre visibles (prioridad alta)
                {
                    targets: [0],
                    responsivePriority: 1
                }, // ID
                {
                    targets: [1],
                    responsivePriority: 2
                }, // Fecha
                {
                    targets: [4],
                    responsivePriority: 3
                }, // Valor Factura
                {
                    targets: [9],
                    responsivePriority: 4
                }, // Total

                // Columnas colapsables (prioridad baja)
                {
                    targets: [2],
                    responsivePriority: 10001
                }, // FEL Serie
                {
                    targets: [3],
                    responsivePriority: 10002
                }, // No. SAT
                {
                    targets: [5],
                    responsivePriority: 10003
                }, // No. Nota Débito
                {
                    targets: [6],
                    responsivePriority: 10004
                }, // Valor Nota Débito
                {
                    targets: [7],
                    responsivePriority: 10005
                }, // No. NC
                {
                    targets: [8],
                    responsivePriority: 10006
                }, // Valor NC
            ],
            drawCallback: function() {
                calcularTotales();
            }
        };

        // Función de cálculo de totales corregida
        function calcularTotales() {
            const tabla = $('#tabla-reportes').DataTable();
            let totalFactura = 0;
            let totalDebito = 0;
            let totalCredito = 0;
            let totalSaldo = 0;

            // Calcular totales solo de las filas visibles después de filtros
            tabla.rows({ filter: 'applied' }).every(function() {
                const fila = this.node();
                const celdas = $(fila).find('td');

                if (celdas.length >= 10) {
                    // Columna 4 = Valor Factura, Columna 9 = Total (Saldo)
                    const valorFactura = parseFloat($(celdas[4]).attr('data-valor')) || 0;
                    const saldoCliente = parseFloat($(celdas[9]).attr('data-saldo')) || 0;

                    // Obtener valores de notas de débito y crédito del texto
                    const textoDebito = $(celdas[6]).text().replace('Q', '').replace(/,/g, '');
                    const textoCredito = $(celdas[8]).text().replace('Q', '').replace(/,/g, '');

                    const valorDebito = parseFloat(textoDebito) || 0;
                    const valorCredito = parseFloat(textoCredito) || 0;

                    totalFactura += valorFactura;
                    totalDebito += valorDebito;
                    totalCredito += valorCredito;
                    totalSaldo += saldoCliente;
                }
            });

            // Actualizar elementos del DOM
            $('#total-factura').text(formatearMoneda(totalFactura));
            $('#total-debito').text(formatearMoneda(totalDebito));
            $('#total-credito').text(formatearMoneda(totalCredito));
            $('#total-saldo').text(formatearMoneda(totalSaldo));
            $('#resumen-facturas').text(formatearMoneda(totalFactura));
            $('#resumen-debito').text(formatearMoneda(totalDebito));
            $('#resumen-credito').text(formatearMoneda(totalCredito));
            $('#resumen-saldo').text(formatearMoneda(totalSaldo));
        }

        function formatearMoneda(cantidad) {
            return 'Q' + new Intl.NumberFormat('es-GT', {
                minimumFractionDigits: 2,
                maximumFractionDigits: 2
            }).format(cantidad);
        }

        // Inicialización cuando el DOM esté listo
        $(document).ready(function() {
            // Inicializar DataTable
            const tabla = $('#tabla-reportes').DataTable(configDataTable);

            // Calcular totales después de inicializar
            setTimeout(function() {
                calcularTotales();
            }, 500);

            // Recalcular totales cuando se realice una búsqueda
            tabla.on('search.dt', function() {
                calcularTotales();
            });

            // Recalcular totales cuando cambie la página
            tabla.on('page.dt', function() {
                calcularTotales();
            });

            // Recalcular totales cuando se ordene una columna
            tabla.on('order.dt', function() {
                calcularTotales();
            });
        });
    </script>
@endsection
