@extends('layouts.app')

@section('content')
@extends('ventas.menu')

<div id="contenedor-dashboard" class="container-fluid">
    <div class="row ">
      <div class="col-md-12">
        <h2>Pedidos a facturar</h2>
      </div>
    </div>
    <div class="col-md-12">
      <br>
      <table id="example" class="display" style="width:100%">
        <thead>
          <tr>
            <td>Tipo</td>
            <td>Fecha</td>
            <td>Cliente</td>
            <td>Cantidad</td>
            <td>Producto</td>
            <td>Cotización</td>
            <td>Observaciones</td>
            <td>Acción</td>
          </tr>
        </thead>
        <tbody>      
          @foreach ($salidasAlmacen as $op)
            <tr>
              <td>{{$op->id}}</td>
              <td>{{date("d/m/Y h:i:s", strtotime($op->created_at))}}</td>
              <td>{{$op->cliente->nombre??''}}</td>
              <td>{{$op->cantidad}}</td>
              <td>{{$op->producto->nombre}}</td>
              <td>
              @if($op->op)
              <a  href="{{ asset('/cotizaciones/CO_'.$op->op->id_cotizacion_producto.'.pdf') }}" target='_blank'>{{$op->op->id_cotizacion_producto}}<i class="far fa-file-pdf"></i></a> 
              @endif  
              </td>
              <td>Facturar</td>
              <td>
              @if($op->op)
                <a href="{{route('ventas.factura',$op->op->id_cotizacion_producto)}}" class=""><i class="fas fa-clipboard-check"></i></a>
                @endif    
              </td>
            </tr>
          @endforeach
        </tbody>
      </table>
    </div>
</div>
@endsection
